'use strict';

/* Controllers */
var OfficeKRSCtrl = ['$scope', '$rootScope', '$location', '$route', 'FrontCreatorCompanyForLoggedUser', 'FrontCreatorCompanyConfirmStage', function($scope, $rootScope, $location, $route, FrontCreatorCompanyForLoggedUser, FrontCreatorCompanyConfirmStage){
    var myPlayerName = "creator_office_krs";
    var myPlayer = _V_(myPlayerName);
    var addCuepointForVideojs = true;

    $rootScope.$on('Tutorial:open', function(event, type){
        myPlayer.pause();
    });

    $scope.CreatorStage = $route.current.locals.creatorStage;
    $scope.currentPoint = {};
    $scope.indexTokenPart = 5;
    $scope.returnedPartsList = {5:4};
    $scope.krsList = [
        {'name':'KRS-W3','required':true,'checked':false},
        {'name':'KRS-W4','required':false,'checked':false},
        {'name':'KRS-WM','required':true,'checked':false},
        {'name':'KRS-WC','required':false,'checked':false},
        {'name':'KRS-WE','required':true,'checked':false},
        {'name':'KRS-WK','required':true,'checked':false},
        {'name':'KRS-Z3','required':false,'checked':false},
        {'name':'KRS-WA','required':false,'checked':false},
        {'name':'KRS-WL','required':false,'checked':false},
        {'name':'Umowa spółki (2 kopie)','required':true,'checked':false},
        {'name':'Protokół ze zgromadzenia zarządu','required':false,'checked':false},
        {'name':'Oświadczenie członków Zarządu o wkładach na pokrycie kapitału','required':true,'checked':false},
        {'name':'dowód ustanowienia organów spółki z wyszczególnieniem składu osobowego<br>(jeśli nie zawarto w umowie)','required':true,'checked':false},
        {'name':'lista wspólników','required':true,'checked':false},
        {'name':'wzory podpisów członków Zarządu','required':true,'checked':false},
        {'name':'dowód uiszczenia opłaty sądowej oraz opłaty za zgłoszenie <br>w Monitorze Sądowym i Gospodarczym','required':true,'checked':false},
        {'name':'umowa z bankiem na prowadzenie rachunku bieżącego','required':false,'checked':false},
        {'name':'oryginał dokumentu potwierdzający prawo do lokalu','required':true,'checked':false},
    ];

    $scope.init = function() {
        $('#wrap').removeClass('start-page');
        var partListPlayFalse = [];
        angular.forEach($scope.CreatorStage.parts, function(part) {
            part.play = (in_array(part.index, partListPlayFalse)) ? false : true;
            part.hide = false;
        });

        var active = true;
        angular.forEach($scope.CreatorStage.steps, function(step) {
            step.active =  active;
            active = false;
        });

        $scope.addCuepointForVideojs();
    }

    $scope.addCuepointForVideojs = function(){
        if(addCuepointForVideojs) {
            videojs(myPlayerName).ready(function(){
                var $this = this;
                $this.cuepoints();
                angular.forEach($scope.CreatorStage.parts, function(part){
                    $this.addCuepoint({
                        namespace: "logger",
                        start: part.end,
                        end: part.end + 0.5,
                        onStart: function(params){
                            if(params.error){
                            }else{
                                myPlayer.pause();
                                if($scope.returnedPartsList[part.index]){
                                    myPlayer.currentTime(part.start-0.5).play();
                                    return;
                                }
                                if(part.percent_point != 0) {
                                    hiddenControlVideo();
                                }
                                $rootScope.$broadcast('DialogPanelNotary:show', part);
                            }
                        },
                        onEnd: function(params){
                            myPlayer.play();
                        },
                        params: {error: false}
                    });
                });
            });
            addCuepointForVideojs = false;
            myPlayer.ready(function(){
                this.on("ended", function(){
                    $rootScope.$broadcast('Tokens:openSubmitCreatorModal', 'x');
                });
            });
        }
    }

    $scope.$on('DialogPanelNotary:show', function(event, part){
        $scope.currentPoint = part;
        $scope.$apply();
        $(".nano").nanoScroller({alwaysVisible: true});
    });

    $scope.submitForm = function(form) {
        if (form == undefined || form.$valid) {
            $scope.playVideo();
        } else {
            $scope.showValidation = form.$invalid;
        }
    }

    $scope.submitFormKrs = function() {
        if($scope.checkKrsList()){
            $scope.currentPoint = getNextPoint(getNextPoint($scope.currentPoint));
            myPlayer.currentTime($scope.currentPoint.start);
        }
        $scope.playVideo();
    }

    $scope.playVideo = function(){
        if($scope.currentPoint.step_index > 0){
            var stepCurrent = -1;
            angular.forEach($scope.CreatorStage.steps, function(step){
                if(step.index == $scope.currentPoint.step_index){
                    step.done = true;
                    stepCurrent = step.index;
                }
                step.active = ((stepCurrent+1) == step.index);
            });
        }

        var nextPoint = getNextPoint($scope.currentPoint);
        if(nextPoint.hasOwnProperty('id') && !nextPoint.play) {
            myPlayer.currentTime(nextPoint.end+0.3);
            $scope.currentPoint = nextPoint;
            $scope.submitForm();
        }

        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.showPanel = function($index){
        return ($scope.currentPoint.hasOwnProperty('id') && ($index == $scope.currentPoint.index));
    }

    $scope.isSelectedPanel = function(){
        return ($scope.currentPoint.hasOwnProperty('id'));
    }

    $scope.checkKrs = function(krs){
        krs.checked = !krs.checked;
    }

    $scope.checkKrsList = function(){
        var valid = true;
        angular.forEach($scope.krsList, function(krs){
            if(krs.required && !krs.checked){
                valid = false;
            }
        });
        return valid;
    }

    function getNextPoint(point) {
        if(!point) return $scope.CreatorStage.parts[0];
        var nextPoint = {};
        angular.forEach($scope.CreatorStage.parts, function(part, index){
            if(part.id == point.id) {
                nextPoint = ($scope.CreatorStage.parts[index+1] === undefined) ? {} : $scope.CreatorStage.parts[index+1];
            }
        });
        return nextPoint;
    }

    function hiddenControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","hidden");
        $($('.vjs-progress-control').first()).css("visibility","hidden");
    }

    function showControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","");
        $($('.vjs-progress-control').first()).css("visibility","");
    }

    function in_array(needle, haystack) {
        for(var i in haystack) {
            if(haystack[i] == needle) return true;
        }
        return false;
    }
}]

OfficeKRSCtrl.getCreatorStage = function($q, $route, $rootScope, FrontCreatorStage){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorStage.get({symbol: "OFFICE_KRS"},function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}